CREATE TABLE Clientes_Asistencias(
	Id_Asistencia			INT IDENTITY(0,1),
	Id_Cliente				INT NOT NULL,
	Id_Trans				INT,
	Id_Contrato  			INT,
	Id_Producto				VARCHAR(14),
	Id_Prod_Familia_Sala	INT,
	Id_Prod_Familia_Horario	INT,
	Fecha					DATETIME,
	Asistencia				CHAR(1),
	Fecha_Recup				DATETIME,
	Nota					TEXT,


	CONSTRAINT PK_CLIA PRIMARY KEY (Id_Asistencia)
) 
GO
INSERT INTO Clientes_Asistencias (Id_Cliente) VALUES (0)

GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Clientes ON Clientes_Asistencias (Id_Cliente)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FK_Clia_Clientes FOREIGN KEY(Id_Cliente)
	REFERENCES Clientes (Id_Cliente)
GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Cbtes ON Clientes_Asistencias (Id_Trans)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FK_Clia_Cbtes FOREIGN KEY(Id_Trans)
	REFERENCES Cbtes (Id_Trans)
GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Contratos ON Clientes_Asistencias (Id_Contrato)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FK_Clia_Contratos FOREIGN KEY(Id_Contrato)
	REFERENCES Contratos (Id_Contrato)
GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Productos ON Clientes_Asistencias (Id_Producto)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FX_Clia_Productos FOREIGN KEY(Id_Producto)
	REFERENCES Productos (Id_Producto)
GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Prod_Familias_Salas ON Clientes_Asistencias (Id_Prod_Familia_Sala)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FX_Clia_Prod_Familias_Salas FOREIGN KEY(Id_Prod_Familia_Sala)
	REFERENCES Prod_Familias_Salas (Id_Prod_Familia_Sala)
GO
-------------------------------------------------------------------
CREATE INDEX IX_Clia_Prod_Familias_Horarios ON Clientes_Asistencias (Id_Prod_Familia_Horario)
GO
ALTER TABLE Clientes_Asistencias  ADD  CONSTRAINT FX_Clia_Prod_Familias_Horarios FOREIGN KEY(Id_Prod_Familia_Horario)
	REFERENCES Prod_Familias_Horarios (Id_Prod_Familia_Horario)
GO


